<?php $__env->startSection('title', 'Appointments'); ?>

<?php $__env->startSection('content'); ?>
<h1 class="h3 mb-4">Appointments</h1>

<div class="card">
    <div class="card-body">
        <?php if($appointments->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Patient Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Preferred Time</th>
                        <th>Doctor</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($appointment->name); ?></td>
                        <td><?php echo e($appointment->email); ?></td>
                        <td><?php echo e($appointment->phone); ?></td>
                        <td><?php echo e($appointment->preferred_time->format('M d, Y h:i A')); ?></td>
                        <td><?php echo e($appointment->doctor ? $appointment->doctor->name : 'Any Doctor'); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger')); ?>">
                                <?php echo e(ucfirst($appointment->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e($appointment->created_at->format('M d, Y')); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.appointments.show', $appointment)); ?>" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <p class="text-muted mb-0">No appointments found.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/appointments/index.blade.php ENDPATH**/ ?>